--==========================================================================================================================
-- DIPLOMATIC ACTIONS
--==========================================================================================================================
-- DiplomaticActions
--------------------------------------------------------------------------------------------------------------------------
UPDATE DiplomaticActions
SET InitiatorPrereqCivic = 'CIVIC_REFORMED_CHURCH'
WHERE DiplomaticActionType = 'DIPLOACTION_DECLARE_HOLY_WAR'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_DIPLOMACY_CHANGES_HOLY_WAR' AND Value = 1);
--==========================================================================================================================
-- TYPES
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Types
		(Type, 										Kind)
VALUES  ('GOVERNMENT_JFD_ABSOLUTE_MONARCHY',  		'KIND_GOVERNMENT'),
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',  'KIND_GOVERNMENT'),
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 			'KIND_GOVERNMENT');
--==========================================================================================================================
-- GREAT PEOPLE
--==========================================================================================================================
-- GreatPersonClasses
--------------------------------------------------------------------------------------------------------------------------
UPDATE GreatPersonClasses
SET MaxPlayerInstances = null
WHERE GreatPersonClassType = 'GREAT_PERSON_CLASS_PROPHET'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_GREAT_PEOPLE_CHANGES_PROPHET' AND Value = 1);
--==========================================================================================================================
-- UNITS
--==========================================================================================================================
-- Tags
--------------------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO Tags
		(Tag, 										Vocabulary)
VALUES  ('CLASS_BUILDER',  							'ABILITY_CLASS'),		
		('CLASS_SETTLER',  							'ABILITY_CLASS');		
--------------------------------------------------------------------------------------------------------------------------
-- TypeTags
--------------------------------------------------------------------------------------------------------------------------
INSERT OR REPLACE INTO TypeTags
		(Type, 										Tag)
VALUES  ('UNIT_BUILDER',  							'CLASS_BUILDER'),		
		('UNIT_SETTLER',  							'CLASS_SETTLER');	
--==========================================================================================================================
-- CIVILOPEDIA
--==========================================================================================================================
-- CivilopediaPageGroups
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO CivilopediaPageGroups
		(SectionID, 		PageGroupID,			Name,															Tooltip, VisibleIfEmpty, SortIndex)
VALUES  ('GOVERNMENTS',  	'SLOT_JFD_RELIGIOUS',	'LOC_PEDIA_GOVERNMENTS_PAGEGROUP_JFD_RELIGIOUS_POLICIES_NAME',	"",		 1,				 60);
--==========================================================================================================================
-- GOVERNMENTS
--==========================================================================================================================
-- Governments
--------------------------------------------------------------------------------------------------------------------------
--ANCIENT
--Chiefdom
UPDATE Governments
SET LeaderTitle = 'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE'
WHERE GovernmentType = 'GOVERNMENT_CHIEFDOM';

--CLASSICAL
--Autocracy
UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_AUTOCRACY_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_AUTOCRACY', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_AUTOCRACY', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_AUTOCRACY', BonusType = 'GOVERNMENTBONUS_UNIT_PRODUCTION'
WHERE GovernmentType = 'GOVERNMENT_AUTOCRACY';

--Democracy
UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_CLASSICAL_DEMOCRACY', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_CLASSICAL_DEMOCRACY', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_CLASSICAL_DEMOCRACY'
WHERE GovernmentType = 'GOVERNMENT_CLASSICAL_REPUBLIC';

UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_CLASSICAL_REPUBLIC_NAME'
WHERE GovernmentType = 'GOVERNMENT_CLASSICAL_REPUBLIC'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_NAME_CLASSICAL_REPUBLIC' AND Value = 1);

--Oligarchy
UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_OLIGARCHY_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_OLIGARCHY', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_OLIGARCHY', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_OLIGARCHY'
WHERE GovernmentType = 'GOVERNMENT_OLIGARCHY';

--MEDIEVAL
--Feudal Monarchy
UPDATE Governments
SET PrereqCivic = 'CIVIC_FEUDALISM', Name = 'LOC_GOVERNMENT_JFD_FEUDAL_MONARCHY_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_FEUDAL_MONARCHY_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_FEUDAL_MONARCHY', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_FEUDAL_MONARCHY', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_FEUDAL_MONARCHY', BonusType = 'GOVERNMENTBONUS_DISTRICT_PROJECTS'
WHERE GovernmentType = 'GOVERNMENT_MONARCHY';

--Merchant Republic
UPDATE Governments
SET PrereqCivic = 'CIVIC_NAVAL_TRADITION', Name = 'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_MERCHANT_REPUBLIC', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_MERCHANT_REPUBLIC', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_MERCHANT_REPUBLIC'
WHERE GovernmentType = 'GOVERNMENT_MERCHANT_REPUBLIC';

--Theocracy
UPDATE Governments
SET PrereqCivic = 'CIVIC_DIVINE_RIGHT', Name = 'LOC_GOVERNMENT_JFD_THEOCRACY_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_THEOCRACY', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_THEOCRACY', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_THEOCRACY'
WHERE GovernmentType = 'GOVERNMENT_THEOCRACY';

--MODERN
--Liberal Democracy
UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_LIBERAL_DEMOCRACY', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_LIBERAL_DEMOCRACY', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_LIBERAL_DEMOCRACY', InfluencePointsPerTurn = 9, InfluencePointsThreshold = 250, InfluenceTokensPerThreshold = 4, OtherGovernmentIntolerance = -4, BonusType = 'NO_GOVERNMENTBONUS'
WHERE GovernmentType = 'GOVERNMENT_DEMOCRACY';

UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_REPRESENTATIVE_DEMOCRACY_NAME'
WHERE GovernmentType = 'GOVERNMENT_DEMOCRACY'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_NAME_REPRESENTATIVE_DEMOCRACY' AND Value = 1);

--Military Guardianship
UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_MILITARY_GUARDIANSHIP', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_MILITARY_GUARDIANSHIP', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_MILITARY_GUARDIANSHIP', InfluencePointsPerTurn = 9, InfluencePointsThreshold = 250, InfluenceTokensPerThreshold = 4, OtherGovernmentIntolerance = -7, BonusType = 'NO_GOVERNMENTBONUS'
WHERE GovernmentType = 'GOVERNMENT_FASCISM';

UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_MILITARY_DICTATORSHIP_NAME'
WHERE GovernmentType = 'GOVERNMENT_FASCISM'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_NAME_MILITARY_DICTATORSHIP' AND Value = 1);

UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_DICTATORSHIP_NAME'
WHERE GovernmentType = 'GOVERNMENT_FASCISM'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_NAME_DICTATORSHIP' AND Value = 1);

--People's Republic
UPDATE Governments
SET Name = 'LOC_GOVERNMENT_JFD_PEOPLES_REPUBLIC_NAME', LeaderTitle = 'LOC_GOVERNMENT_JFD_PEOPLES_REPUBLIC_LEADER_TITLE', InherentBonusDesc = 'LOC_GOVT_INHERENT_BONUS_JFD_PEOPLES_REPUBLIC', AccumulatedBonusShortDesc = 'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_PEOPLES_REPUBLIC', AccumulatedBonusDesc = 'LOC_GOVT_ACCUMULATED_BONUS_JFD_PEOPLES_REPUBLIC', InfluencePointsPerTurn = 9, InfluencePointsThreshold = 250, InfluenceTokensPerThreshold = 4, OtherGovernmentIntolerance = -6, BonusType = 'NO_GOVERNMENTBONUS'
WHERE GovernmentType = 'GOVERNMENT_COMMUNISM';	

--RENAISSANCE
INSERT INTO Governments
		(GovernmentType,										Name, 												LeaderTitle,												PrereqCivic, 					InherentBonusDesc, 										AccumulatedBonusShortDesc, 											AccumulatedBonusDesc, 										OtherGovernmentIntolerance, 	InfluencePointsPerTurn, InfluencePointsThreshold, 	InfluenceTokensPerThreshold, BonusType)
VALUES	('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'LOC_GOVERNMENT_JFD_ABSOLUTE_MONARCHY_NAME', 		'LOC_GOVERNMENT_JFD_ABSOLUTE_MONARCHY_LEADER_TITLE',		'CIVIC_THE_ENLIGHTENMENT',  	'LOC_GOVT_INHERENT_BONUS_JFD_ABSOLUTE_MONARCHY', 		'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_ABSOLUTE_MONARCHY', 			'LOC_GOVT_ACCUMULATED_BONUS_JFD_ABSOLUTE_MONARCHY', 		-6, 							7, 						200, 						3, 							 'GOVERNMENTBONUS_WONDER_CONSTRUCTION'),
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'LOC_GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY_NAME', 	'LOC_GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY_LEADER_TITLE',	'CIVIC_THE_ENLIGHTENMENT',  	'LOC_GOVT_INHERENT_BONUS_JFD_CONSTITUTIONAL_MONARCHY', 	'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_CONSTITUTIONAL_MONARCHY', 	'LOC_GOVT_ACCUMULATED_BONUS_JFD_CONSTITUTIONAL_MONARCHY', 	-3, 							7, 						200, 						3, 							 'GOVERNMENTBONUS_ENVOYS'),
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_NAME', 			'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE',			'CIVIC_THE_ENLIGHTENMENT',  	'LOC_GOVT_INHERENT_BONUS_JFD_NOBLE_REPUBLIC', 			'LOC_GOVT_ACCUMULATED_BONUS_BRIEF_JFD_NOBLE_REPUBLIC', 				'LOC_GOVT_ACCUMULATED_BONUS_JFD_NOBLE_REPUBLIC', 			-5, 							7, 						200, 						3, 							 'GOVERNMENTBONUS_OVERALL_PRODUCTION');
--------------------------------------------------------------------------------------------------------------------------
-- GovernmentBonusNames
--------------------------------------------------------------------------------------------------------------------------
-- INSERT INTO GovernmentBonusNames
		-- (GovernmentBonusType, 						    BonusValue)
-- VALUES  ('GOVERNMENTBONUS_JFD_CULTURE',  				9),
		-- ('GOVERNMENTBONUS_JFD_FAITH_GOLD',  			10),
		-- ('GOVERNMENTBONUS_JFD_SCIENCE',  				11);
--------------------------------------------------------------------------------------------------------------------------
-- GovernmentModifiers
--------------------------------------------------------------------------------------------------------------------------
DELETE FROM GovernmentModifiers WHERE GovernmentType IN ('GOVERNMENT_MONARCHY', 'GOVERNMENT_DEMOCRACY', 'GOVERNMENT_COMMUNISM', 'GOVERNMENT_FASCISM', 'GOVERNMENT_AUTOCRACY');
INSERT INTO GovernmentModifiers
		(GovernmentType,										ModifierId)
VALUES	('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'JFD_ABSOLUTE_MONARCHY_LAND_CORPS_EARLY'),
		('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'AUTOCRACY_WONDERS'),
		('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'AUTOCRACY_WONDERS_ACCUMULATING'),
		('GOVERNMENT_AUTOCRACY', 								'AUTOCRACY_CULTURE'),	
		('GOVERNMENT_AUTOCRACY', 								'AUTOCRACY_FOOD'),	
		('GOVERNMENT_AUTOCRACY', 								'AUTOCRACY_GOLD'),	
		('GOVERNMENT_AUTOCRACY', 								'AUTOCRACY_PRODUCTION'),	
		('GOVERNMENT_AUTOCRACY', 								'AUTOCRACY_SCIENCE'),	
		('GOVERNMENT_AUTOCRACY', 								'AUTOCRACY_FAITH'),	
		('GOVERNMENT_AUTOCRACY', 								'FASCISM_UNIT_PRODUCTION'),	
		('GOVERNMENT_AUTOCRACY', 								'FASCISM_UNIT_PRODUCTION_ACCUMULATING'),	
		('GOVERNMENT_COMMUNISM', 								'COMMUNISM_DEFENSE'),	
		('GOVERNMENT_COMMUNISM', 								'JFD_PEOPLES_REPUBLIC_SCIENCE_MODIFIER'),	
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'JFD_CONSTITUTIONAL_MONARCHY_CIVIC_BOOST'),
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'JFD_CONSTITUTIONAL_MONARCHY_TECH_BOOST'),
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'MONARCHY_ENVOYS'),
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'MONARCHY_ENVOYS_ACCUMULATING'),
		--('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 			'JFD_CONSTITUTIONAL_MONARCHY_TOURISM'),	
		--('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 			'JFD_CONSTITUTIONAL_MONARCHY_TOURISM_ACCUMULATING'),	
		('GOVERNMENT_DEMOCRACY', 								'DEMOCRACY_PATRONAGE_GOLD_DISCOUNT'),	
		('GOVERNMENT_DEMOCRACY', 								'JFD_LIBERAL_DEMOCRACY_TOURISM_MODIFIER'),	
		('GOVERNMENT_FASCISM', 									'FASCISM_ATTACK'),	
		('GOVERNMENT_FASCISM', 									'JFD_MILITARY_GUARDIANSHIP_FAITH_MODIFIER'),	
		('GOVERNMENT_FASCISM', 									'JFD_MILITARY_GUARDIANSHIP_GOLD_MODIFIER'),	
		--('GOVERNMENT_MONARCHY', 								'JFD_FEUDAL_MONARCHY_BORDERS'),	
		--('GOVERNMENT_MONARCHY', 								'JFD_FEUDAL_MONARCHY_BORDERS_ACCUMULATING'),	
		('GOVERNMENT_MONARCHY', 								'MONARCHY_CASTLE_HOUSING'),	
		('GOVERNMENT_MONARCHY', 								'DEMOCRACY_DISTRICT_PROCESSES'),	
		('GOVERNMENT_MONARCHY', 								'DEMOCRACY_DISTRICT_PROCESSES_ACCUMULATING'),	
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'JFD_NOBLE_REPUBLIC_EXTRA_DISTRICT'),
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'COMMUNISM_ALL_PRODUCTION'),
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'COMMUNISM_ALL_PRODUCTION_ACCUMULATING');
--------------------------------------------------------------------------------------------------------------------------
-- GovernmentSlots
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO GovernmentSlots
		(GovernmentSlotType, 									Name,								AllowsAnyPolicy)
VALUES  ('SLOT_JFD_RELIGIOUS', 									'LOC_SLOT_JFD_RELIGIOUS_NAME',		0);
--------------------------------------------------------------------------------------------------------------------------
-- Government_SlotCounts
--------------------------------------------------------------------------------------------------------------------------
DELETE FROM Government_SlotCounts WHERE GovernmentType IN ('GOVERNMENT_CHIEFDOM', 'GOVERNMENT_AUTOCRACY', 'GOVERNMENT_CLASSICAL_REPUBLIC', 'GOVERNMENT_OLIGARCHY', 'GOVERNMENT_MONARCHY', 'GOVERNMENT_MERCHANT_REPUBLIC', 'GOVERNMENT_THEOCRACY', 'GOVERNMENT_FASCISM', 'GOVERNMENT_COMMUNISM', 'GOVERNMENT_DEMOCRACY');
INSERT INTO Government_SlotCounts
		(GovernmentType, 										GovernmentSlotType,		NumSlots)
VALUES  --Ancient			
		('GOVERNMENT_CHIEFDOM',									'SLOT_MILITARY',		1), --Chiefdom
		('GOVERNMENT_CHIEFDOM',									'SLOT_WILDCARD',		1), --Chiefdom
		--Classical			
		('GOVERNMENT_AUTOCRACY', 								'SLOT_ECONOMIC',		1), --Autocracy
		('GOVERNMENT_AUTOCRACY', 								'SLOT_MILITARY',		1), --Autocracy
		('GOVERNMENT_AUTOCRACY', 								'SLOT_JFD_RELIGIOUS',	1), --Autocracy
		('GOVERNMENT_AUTOCRACY', 								'SLOT_WILDCARD',		1), --Autocracy
		('GOVERNMENT_CLASSICAL_REPUBLIC', 						'SLOT_DIPLOMATIC',		1), --Democracy
		('GOVERNMENT_CLASSICAL_REPUBLIC', 						'SLOT_ECONOMIC',		2), --Democracy
		('GOVERNMENT_CLASSICAL_REPUBLIC', 						'SLOT_WILDCARD',		1), --Democracy
		('GOVERNMENT_OLIGARCHY', 								'SLOT_DIPLOMATIC',		1), --Oligarchy
		('GOVERNMENT_OLIGARCHY', 								'SLOT_ECONOMIC',		1), --Oligarchy
		('GOVERNMENT_OLIGARCHY', 								'SLOT_MILITARY',		1), --Oligarchy
		('GOVERNMENT_OLIGARCHY', 								'SLOT_WILDCARD',		1), --Oligarchy
		--Medieval			
		('GOVERNMENT_MONARCHY', 								'SLOT_ECONOMIC',		2), --Feudal Monarchy
		('GOVERNMENT_MONARCHY', 								'SLOT_MILITARY',		3), --Feudal Monarchy
		('GOVERNMENT_MONARCHY', 								'SLOT_WILDCARD',		1), --Feudal Monarchy
		('GOVERNMENT_MERCHANT_REPUBLIC', 						'SLOT_ECONOMIC',		3), --Merchant Republic
		('GOVERNMENT_MERCHANT_REPUBLIC', 						'SLOT_DIPLOMATIC',		2), --Merchant Republic
		('GOVERNMENT_MERCHANT_REPUBLIC', 						'SLOT_WILDCARD',		1), --Merchant Republic
		('GOVERNMENT_THEOCRACY', 								'SLOT_JFD_RELIGIOUS',	3), --Theocracy
		('GOVERNMENT_THEOCRACY', 								'SLOT_MILITARY',		1), --Theocracy
		('GOVERNMENT_THEOCRACY', 								'SLOT_WILDCARD',		2), --Theocracy
		--Renaissance			
		('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'SLOT_ECONOMIC',		2), --Absolute Monarchy
		('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'SLOT_MILITARY',		2), --Absolute Monarchy
		('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'SLOT_JFD_RELIGIOUS',	1), --Absolute Monarchy
		('GOVERNMENT_JFD_ABSOLUTE_MONARCHY', 					'SLOT_WILDCARD',		2), --Absolute Monarchy
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'SLOT_DIPLOMATIC',		2), --Constitutional Monarchy
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'SLOT_ECONOMIC',		2), --Constitutional Monarchy
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'SLOT_JFD_RELIGIOUS',	2), --Constitutional Monarchy
		('GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY', 				'SLOT_WILDCARD',		1), --Constitutional Monarchy
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'SLOT_DIPLOMATIC',		1), --Noble Republic
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'SLOT_ECONOMIC',		3), --Noble Republic
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'SLOT_MILITARY',		2), --Noble Republic
		('GOVERNMENT_JFD_NOBLE_REPUBLIC', 						'SLOT_WILDCARD',		1), --Noble Republic
		--Modern			
		('GOVERNMENT_FASCISM', 									'SLOT_ECONOMIC',		1), --Military Guardianship
		('GOVERNMENT_FASCISM', 									'SLOT_MILITARY',		4), --Military Guardianship
		('GOVERNMENT_FASCISM', 									'SLOT_JFD_RELIGIOUS',	1), --Military Guardianship
		('GOVERNMENT_FASCISM', 									'SLOT_WILDCARD',		2), --Military Guardianship
		('GOVERNMENT_DEMOCRACY', 								'SLOT_ECONOMIC',		3), --Liberal Democracy
		('GOVERNMENT_DEMOCRACY', 								'SLOT_DIPLOMATIC',		2), --Liberal Democracy
		('GOVERNMENT_DEMOCRACY', 								'SLOT_MILITARY',		1), --Liberal Democracy
		('GOVERNMENT_DEMOCRACY', 								'SLOT_JFD_RELIGIOUS',	1), --Liberal Democracy
		('GOVERNMENT_DEMOCRACY', 								'SLOT_WILDCARD',		1), --Liberal Democracy
		('GOVERNMENT_COMMUNISM', 								'SLOT_DIPLOMATIC',		1), --People's Republic
		('GOVERNMENT_COMMUNISM', 								'SLOT_ECONOMIC',		3), --People's Republic
		('GOVERNMENT_COMMUNISM', 								'SLOT_MILITARY',		3), --People's Republic
		('GOVERNMENT_COMMUNISM', 								'SLOT_WILDCARD',		1); --People's Republic
--------------------------------------------------------------------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Modifiers
		(ModifierId,											ModifierType,														SubjectRequirementSetId)
VALUES	('JFD_ABSOLUTE_MONARCHY_CORPS_ARMY_DISCOUNT',			'MODIFIER_CITY_CORPS_ARMY_ADJUST_DISCOUNT',							null),
		('JFD_ABSOLUTE_MONARCHY_LAND_CORPS_EARLY',				'MODIFIER_PLAYER_CORPS_ARMY_PREREQ',								null),
		('JFD_CONSTITUTIONAL_MONARCHY_CIVIC_BOOST',				'MODIFIER_PLAYER_ADJUST_CIVIC_BOOST',								null),
		('JFD_CONSTITUTIONAL_MONARCHY_TECH_BOOST',				'MODIFIER_PLAYER_ADJUST_TECHNOLOGY_BOOST',							null),
		('JFD_LIBERAL_DEMOCRACY_TOURISM_MODIFIER',				'MODIFIER_PLAYER_ADJUST_TOURISM',									null),
		('JFD_MILITARY_GUARDIANSHIP_GOLD_MODIFIER',				'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				null),
		('JFD_MILITARY_GUARDIANSHIP_FAITH_MODIFIER',			'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				null),
		('JFD_NOBLE_REPUBLIC_EXTRA_DISTRICT',					'MODIFIER_PLAYER_CITIES_EXTRA_DISTRICT',							null),
		('JFD_PEOPLES_REPUBLIC_SCIENCE_MODIFIER',				'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				null);
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM',					'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				null),
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM_ACCUMULATING',	'MODIFIER_PLAYER_GOVERNMENT_ACCUMULATING_BONUS',					null),
		-- ('JFD_FEUDAL_MONARCHY_BORDERS',							'MODIFIER_PLAYER_GOVERNMENT_FLAT_BONUS',							null),
		-- ('JFD_FEUDAL_MONARCHY_BORDERS_ACCUMULATING',				'MODIFIER_ALL_CITIES_CULTURE_BORDER_EXPANSION',						null),
		-- ('TRAIT_JFD_CONSTITUTIONAL_MONARCHY_BONUS_RATE',		'MODIFIER_PLAYER_GOVERNMENT_ADJUST_BONUS_RATE',						null);	
--------------------------------------------------------------------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,											Name,				Value,											Extra,				Type)
VALUES	('JFD_ABSOLUTE_MONARCHY_CORPS_ARMY_DISCOUNT',			'Domain',			'DOMAIN_LAND',									null,				'ARGTYPE_IDENTITY'),
		('JFD_ABSOLUTE_MONARCHY_CORPS_ARMY_DISCOUNT',			'Amount',			20,												-1,					'ARGTYPE_IDENTITY'),
		('JFD_ABSOLUTE_MONARCHY_LAND_CORPS_EARLY',				'Corps',			1,												null,				'ARGTYPE_IDENTITY'),
		('JFD_ABSOLUTE_MONARCHY_LAND_CORPS_EARLY',				'Domain',			'DOMAIN_LAND',									null,				'ARGTYPE_IDENTITY'),
		('JFD_ABSOLUTE_MONARCHY_LAND_CORPS_EARLY',				'CivicType',		'CIVIC_THE_ENLIGHTENMENT',						null,				'ARGTYPE_IDENTITY'),
		('JFD_CONSTITUTIONAL_MONARCHY_CIVIC_BOOST',				'Amount',			10,												-1,					'ARGTYPE_IDENTITY'),
		('JFD_CONSTITUTIONAL_MONARCHY_TECH_BOOST',				'Amount',			10,												-1,					'ARGTYPE_IDENTITY'),
		('JFD_LIBERAL_DEMOCRACY_TOURISM_MODIFIER',				'Amount',			20,												null,				'ARGTYPE_IDENTITY'),
		('JFD_MILITARY_GUARDIANSHIP_FAITH_MODIFIER',			'YieldType',		'YIELD_FAITH',									null,				'ARGTYPE_IDENTITY'),
		('JFD_MILITARY_GUARDIANSHIP_FAITH_MODIFIER',			'Amount',			10,												null,				'ARGTYPE_IDENTITY'),
		('JFD_MILITARY_GUARDIANSHIP_GOLD_MODIFIER',				'YieldType',		'YIELD_GOLD',									null,				'ARGTYPE_IDENTITY'),
		('JFD_MILITARY_GUARDIANSHIP_GOLD_MODIFIER',				'Amount',			10,												null,				'ARGTYPE_IDENTITY'),
		('JFD_NOBLE_REPUBLIC_EXTRA_DISTRICT',					'Amount',			1,												null,				'ARGTYPE_IDENTITY'),
		('JFD_PEOPLES_REPUBLIC_SCIENCE_MODIFIER',				'YieldType',		'YIELD_SCIENCE',								null,				'ARGTYPE_IDENTITY'),
		('JFD_PEOPLES_REPUBLIC_SCIENCE_MODIFIER',				'Amount',			20,												null,				'ARGTYPE_IDENTITY');
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM',					'YieldType',		'YIELD_PRODUCTION',								null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM',					'BonusType',		'GOVERNMENTBONUS_JFD_TOURISM',					null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM',					'Amount',			100,											null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM_ACCUMULATING',	'YieldType',		'YIELD_PRODUCTION',								null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM_ACCUMULATING',	'BonusType',		'GOVERNMENTBONUS_JFD_TOURISM',					null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM_ACCUMULATING',	'Increment',		5,												null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_CONSTITUTIONAL_MONARCHY_TOURISM_ACCUMULATING',	'Interval',			2,												null,				'ScaleByGameSpeed'),
		-- ('JFD_FEUDAL_MONARCHY_BORDERS',						'BonusType',		'JFD_GOVERNMENTBONUS_BORDERS',					null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_FEUDAL_MONARCHY_BORDERS',						'Amount',			20,												null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_FEUDAL_MONARCHY_BORDERS_ACCUMULATING',			'BonusType',		'JFD_GOVERNMENTBONUS_BORDERS',					null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_FEUDAL_MONARCHY_BORDERS_ACCUMULATING',			'Increment',		1,												null,				'ARGTYPE_IDENTITY'),
		-- ('JFD_FEUDAL_MONARCHY_BORDERS_ACCUMULATING',			'Interval',			10,												null,				'ScaleByGameSpeed'),
		-- ('TRAIT_JFD_CONSTITUTIONAL_MONARCHY_BONUS_RATE',		'BonusRate',		100,											null,				'ARGTYPE_IDENTITY'),
		-- ('TRAIT_JFD_CONSTITUTIONAL_MONARCHY_BONUS_RATE',		'BonusType',		'GOVERNMENTBONUS_JFD_TOURISM',					null,				'ARGTYPE_IDENTITY');	

UPDATE ModifierArguments
SET Value = 20
WHERE ModifierID = 'AUTOCRACY_WONDERS' AND Name = 'Amount';

UPDATE ModifierArguments
SET Value = 20
WHERE ModifierID = 'DEMOCRACY_DISTRICT_PROCESSES' AND Name = 'Amount';
--------------------------------------------------------------------------------------------------------------------------
-- TraitModifiers
--------------------------------------------------------------------------------------------------------------------------
-- INSERT INTO TraitModifiers
		-- (TraitType,												ModifierId)
-- VALUES	('TRAIT_CIVILIZATION_FOUNDING_FATHERS',					'TRAIT_JFD_CONSTITUTIONAL_MONARCHY_BONUS_RATE');	
--==========================================================================================================================
-- TYPES
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Types
		(Type, 												Kind)
VALUES  ('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',			'KIND_ABILITY');
--------------------------------------------------------------------------------------------------------------------------
-- TypeTags
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO TypeTags
		(Type, 												Tag)
VALUES  ('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_RECON'),		
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_MELEE'),	
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_RANGED'),
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_SIEGE'),
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_HEAVY_CHARIOT'),
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_LIGHT_CHARIOT'),
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_HEAVY_CAVALRY'),
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_RANGED_CAVALRY'),
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_LIGHT_CAVALRY'),
		('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',  			'CLASS_ANTI_CAVALRY');
--==========================================================================================================================
-- UNITS
--==========================================================================================================================
-- UnitAbilities
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO UnitAbilities
		(UnitAbilityType, 									Name,										Description,										Inactive)
VALUES  ('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS',			'LOC_ABILITY_JFD_RITUAL_WAR_NAME',			'LOC_ABILITY_JFD_RITUAL_WAR_DESCRIPTION', 			1);
--------------------------------------------------------------------------------------------------------------------------
-- UnitAbilityModifiers
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO UnitAbilityModifiers
		(UnitAbilityType,									ModifierId)
VALUES	('ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS', 			'JFD_RITUAL_WAR_PROPHET_POINTS_FROM_KILLS');		
--------------------------------------------------------------------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------------------------------------------------------------------					
INSERT INTO Modifiers			
		(ModifierId,										ModifierType,														Permanent,	SubjectRequirementSetId)
VALUES	('JFD_RITUAL_WAR_PROPHET_POINTS_FROM_KILLS',		'MODIFIER_PLAYER_UNIT_ADJUST_GREAT_PEOPLE_POINTS_PER_KILL',			0,			null);
--------------------------------------------------------------------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,						Value)
VALUES	('JFD_RITUAL_WAR_PROPHET_POINTS_FROM_KILLS',		'GreatPersonClassType',		'GREAT_PERSON_CLASS_PROPHET'),
		('JFD_RITUAL_WAR_PROPHET_POINTS_FROM_KILLS',		'Amount',					5);	
--==========================================================================================================================
-- TYPES
--==========================================================================================================================
-- Types
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Types
		(Type, 												Kind)
VALUES  --Policies		
		('POLICY_JFD_ARTS_PATRONAGE',  						'KIND_POLICY'),
		('POLICY_JFD_AUTOCEPHALY',  						'KIND_POLICY'),
		('POLICY_JFD_CROWNED_REPUBLIC',  					'KIND_POLICY'),
		('POLICY_JFD_EMPIRE',  								'KIND_POLICY'),
		('POLICY_JFD_FUNDAMENTALISM',  						'KIND_POLICY'),
		('POLICY_JFD_HOSPICES',  							'KIND_POLICY'),
		('POLICY_JFD_INVESTITURE',  						'KIND_POLICY'),
		('POLICY_JFD_MISSIONS',  							'KIND_POLICY'),
		('POLICY_JFD_PACIFISM',  							'KIND_POLICY'),
		('POLICY_JFD_REVIVALISM',  							'KIND_POLICY'),
		('POLICY_JFD_RITUAL_WAR',  							'KIND_POLICY'),
		('POLICY_JFD_SAINTHOOD',  							'KIND_POLICY'),
		('POLICY_JFD_SCHOLASTICISM',  						'KIND_POLICY'),
		('POLICY_JFD_SECULARISM',  							'KIND_POLICY'),
		('POLICY_JFD_SHAMANISM',  							'KIND_POLICY'),
		('POLICY_JFD_STATE_ATHEISM',  						'KIND_POLICY'),
		--Slots		
		('SLOT_JFD_RELIGIOUS',  							'KIND_SLOT');
--==========================================================================================================================
-- POLICIES
--==========================================================================================================================
-- Policies
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Policies	
		(PolicyType,										Name, 										Description, 										PrereqCivic, 					GovernmentSlotType)
VALUES	('POLICY_JFD_ARTS_PATRONAGE', 						'LOC_POLICY_JFD_ARTS_PATRONAGE_NAME', 		'LOC_POLICY_JFD_ARTS_PATRONAGE_DESCRIPTION',  		'CIVIC_HUMANISM', 				'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_AUTOCEPHALY', 							'LOC_POLICY_JFD_AUTOCEPHALY_NAME', 			'LOC_POLICY_JFD_AUTOCEPHALY_DESCRIPTION',  			'CIVIC_CIVIL_SERVICE', 			'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_CROWNED_REPUBLIC', 					'LOC_POLICY_JFD_CROWNED_REPUBLIC_NAME', 	'LOC_POLICY_JFD_CROWNED_REPUBLIC_DESCRIPTION',  	'CIVIC_URBANIZATION', 			'SLOT_ECONOMIC'),
		('POLICY_JFD_EMPIRE', 								'LOC_POLICY_JFD_EMPIRE_NAME', 				'LOC_POLICY_JFD_EMPIRE_DESCRIPTION',  				'CIVIC_EXPLORATION', 			'SLOT_MILITARY'),
		('POLICY_JFD_FUNDAMENTALISM', 						'LOC_POLICY_JFD_FUNDAMENTALISM_NAME', 		'LOC_POLICY_JFD_FUNDAMENTALISM_DESCRIPTION',  		'CIVIC_IDEOLOGY', 				'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_HOSPICES', 							'LOC_POLICY_JFD_HOSPICES_NAME', 			'LOC_POLICY_JFD_HOSPICES_DESCRIPTION',  			'CIVIC_GUILDS', 				'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_INVESTITURE', 							'LOC_POLICY_JFD_INVESTITURE_NAME', 			'LOC_POLICY_JFD_INVESTITURE_DESCRIPTION',  			'CIVIC_THEOLOGY', 				'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_MISSIONS', 							'LOC_POLICY_JFD_MISSIONS_NAME', 			'LOC_POLICY_JFD_MISSIONS_DESCRIPTION',  			'CIVIC_COLONIALISM', 			'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_PACIFISM', 							'LOC_POLICY_JFD_PACIFISM_NAME', 			'LOC_POLICY_JFD_PACIFISM_DESCRIPTION',  			'CIVIC_NATIONALISM', 			'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_RITUAL_WAR', 							'LOC_POLICY_JFD_RITUAL_WAR_NAME', 			'LOC_POLICY_JFD_RITUAL_WAR_DESCRIPTION',  			'CIVIC_MILITARY_TRADITION', 	'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_REVIVALISM', 							'LOC_POLICY_JFD_REVIVALISM_NAME', 			'LOC_POLICY_JFD_REVIVALISM_DESCRIPTION',  			'CIVIC_CULTURAL_HERITAGE', 		'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_SAINTHOOD', 							'LOC_POLICY_JFD_SAINTHOOD_NAME', 			'LOC_POLICY_JFD_SAINTHOOD_DESCRIPTION',  			'CIVIC_REFORMED_CHURCH', 		'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_SCHOLASTICISM', 						'LOC_POLICY_JFD_SCHOLASTICISM_NAME', 		'LOC_POLICY_JFD_SCHOLASTICISM_DESCRIPTION',  		'CIVIC_DIVINE_RIGHT', 			'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_SECULARISM', 							'LOC_POLICY_JFD_SECULARISM_NAME', 			'LOC_POLICY_JFD_SECULARISM_DESCRIPTION',  			'CIVIC_THE_ENLIGHTENMENT', 		'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_SHAMANISM', 							'LOC_POLICY_JFD_SHAMANISM_NAME', 			'LOC_POLICY_JFD_SHAMANISM_DESCRIPTION',  			'CIVIC_MYSTICISM', 				'SLOT_JFD_RELIGIOUS'),
		('POLICY_JFD_STATE_ATHEISM', 						'LOC_POLICY_JFD_STATE_ATHEISM_NAME', 		'LOC_POLICY_JFD_STATE_ATHEISM_DESCRIPTION',  		'CIVIC_COLD_WAR', 				'SLOT_JFD_RELIGIOUS');
	
UPDATE Policies
SET GovernmentSlotType = 'SLOT_JFD_RELIGIOUS'
WHERE PolicyType IN ('POLICY_GOD_KING', 'POLICY_RELIGIOUS_ORDERS', 'POLICY_SCRIPTURE', 'POLICY_SIMULTANEUM', 'POLICY_WARS_OF_RELIGION', 'POLICY_AESTHETICS', 'POLICY_GOTHIC_ARCHITECTURE');
--------------------------------------------------------------------------------------------------------------------------
-- PolicyModifiers
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO PolicyModifiers
		(PolicyType,										ModifierId)
VALUES	('POLICY_JFD_ARTS_PATRONAGE', 						'JFD_ARTS_PATRONAGE_HOLY_SITE_ARTIST_POINTS'),	
		('POLICY_JFD_ARTS_PATRONAGE', 						'JFD_ARTS_PATRONAGE_HOLY_SITE_MUSICIAN_POINTS'),	
		('POLICY_JFD_ARTS_PATRONAGE', 						'JFD_ARTS_PATRONAGE_HOLY_SITE_WRITER_POINTS'),	
		('POLICY_JFD_AUTOCEPHALY', 							'JFD_AUTOCEPHALY_DISTRICT_PRODUCTION_MODIFIER'),	
		('POLICY_JFD_CROWNED_REPUBLIC', 					'JFD_CROWNED_REPUBLIC_CAPITAL_APPEAL'),	
		('POLICY_JFD_EMPIRE', 								'JFD_EMPIRE_BORDER_MODIFIER'),	
		('POLICY_JFD_FUNDAMENTALISM', 						'JFD_FUNDAMENTALISM_SPREAD_DISTANCE'),	
		('POLICY_JFD_FUNDAMENTALISM', 						'JFD_FUNDAMENTALISM_SPREAD_STRENGTH'),	
		('POLICY_JFD_HOSPICES', 							'JFD_HOSPICES_TEMPLE_AMENITY'),	
		('POLICY_JFD_INVESTITURE', 							'JFD_INVESTITURE_SHRINE_PRODUCTION'),
		('POLICY_JFD_INVESTITURE', 							'JFD_INVESTITURE_TEMPLE_PRODUCTION'),
		('POLICY_JFD_MISSIONS', 							'JFD_MISSIONS_FAITH_PURCHASE_BUILDERS'),
		('POLICY_JFD_MISSIONS', 							'JFD_MISSIONS_FAITH_PURCHASE_SETTLERS'),
		('POLICY_JFD_PACIFISM', 							'JFD_PACIFISM_AT_PEACE_FAITH_MODIFIER'),
		('POLICY_JFD_RITUAL_WAR', 							'JFD_RITUAL_WAR_PROPHET_POINTS_ABILITY'),
		('POLICY_JFD_REVIVALISM', 							'JFD_REVIVALISM_MISSIONARY_EXTRA_SPREADS'),
		('POLICY_JFD_SAINTHOOD', 							'JFD_SAINTHOOD_PATRONAGE_FAITH_DISCOUNT'),
		('POLICY_JFD_SECULARISM', 							'JFD_SECULARISM_CAMPUS_SCIENTIST_POINTS'),
		('POLICY_JFD_SECULARISM', 							'JFD_SECULARISM_COMMERCIAL_HUB_MERCHANT_POINTS'),
		('POLICY_JFD_SECULARISM', 							'JFD_SECULARISM_INDUSTRIAL_ZONE_ENGINEER_POINTS'),
		('POLICY_JFD_SCHOLASTICISM', 						'JFD_SCHOLASTICISM_MADRASA_FAITH_MODIFIER'),
		('POLICY_JFD_SCHOLASTICISM', 						'JFD_SCHOLASTICISM_UNIVERSITY_FAITH_MODIFIER'),
		('POLICY_JFD_SHAMANISM', 							'JFD_SHAMANISM_UNITS_ADJUST_HEAL_PER_TURN'),
		('POLICY_JFD_STATE_ATHEISM', 						'JFD_STATE_ATHEISM_FAITH_MODIFIER'),
		('POLICY_JFD_STATE_ATHEISM', 						'JFD_STATE_ATHEISM_PRODUCTION_MODIFIER');
--------------------------------------------------------------------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------------------------------------------------------------------					
INSERT INTO Modifiers			
		(ModifierId,										ModifierType,														Permanent,	SubjectRequirementSetId)
VALUES	('JFD_ARTS_PATRONAGE_HOLY_SITE_ARTIST_POINTS',		'MODIFIER_PLAYER_DISTRICTS_ADJUST_GREAT_PERSON_POINTS',				0,			'DISTRICT_IS_THEATER'),
		('JFD_ARTS_PATRONAGE_HOLY_SITE_MUSICIAN_POINTS',	'MODIFIER_PLAYER_DISTRICTS_ADJUST_GREAT_PERSON_POINTS',				0,			'DISTRICT_IS_THEATER'),
		('JFD_ARTS_PATRONAGE_HOLY_SITE_WRITER_POINTS',		'MODIFIER_PLAYER_DISTRICTS_ADJUST_GREAT_PERSON_POINTS',				0,			'DISTRICT_IS_THEATER'),
		('JFD_AUTOCEPHALY_DISTRICT_PRODUCTION_MODIFIER',	'MODIFIER_PLAYER_CITIES_ADJUST_ALL_PROJECTS_PRODUCTION',			0,			null),
		('JFD_CROWNED_REPUBLIC_CAPITAL_APPEAL',				'MODIFIER_PLAYER_CITIES_ADJUST_CITY_APPEAL',						0,			'JFD_CITY_HAS_PALACE_REQUIREMENTS'),
		('JFD_CROWNED_REPUBLIC_CAPITAL_TOURISM',			'MODIFIER_PLAYER_CITIES_ADJUST_TOURISM',							0,			'JFD_CITY_HAS_PALACE_REQUIREMENTS'),
		('JFD_EMPIRE_BORDER_MODIFIER',						'MODIFIER_ALL_CITIES_CULTURE_BORDER_EXPANSION',						0,			null),
		('JFD_FUNDAMENTALISM_SPREAD_DISTANCE',				'MODIFIER_PLAYER_RELIGION_ADJUST_RELIGIOUS_SPREAD_DISTANCE',		0,			null),
		('JFD_FUNDAMENTALISM_SPREAD_STRENGTH',				'MODIFIER_PLAYER_RELIGION_ADJUST_RELIGIOUS_SPREAD_STRENGTH',		0,			null),
		('JFD_HOSPICES_TEMPLE_AMENITY',						'MODIFIER_PLAYER_CITIES_ADJUST_POLICY_AMENITY',						0,			'JFD_CITY_HAS_TEMPLE_REQUIREMENTS'),
		('JFD_INVESTITURE_SHRINE_PRODUCTION',				'MODIFIER_PLAYER_CITIES_ADJUST_BUILDING_PRODUCTION',				0,			null),
		('JFD_INVESTITURE_TEMPLE_PRODUCTION',				'MODIFIER_PLAYER_CITIES_ADJUST_BUILDING_PRODUCTION',				0,			null),
		('JFD_MISSIONS_FAITH_PURCHASE_BUILDERS',			'MODIFIER_PLAYER_CITIES_ENABLE_UNIT_FAITH_PURCHASE',				0,			null),
		('JFD_MISSIONS_FAITH_PURCHASE_SETTLERS',			'MODIFIER_PLAYER_CITIES_ENABLE_UNIT_FAITH_PURCHASE',				0,			null), 
		('JFD_PACIFISM_AT_PEACE_FAITH_MODIFIER',			'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				0,			'PLAYER_IS_AT_PEACE_WITH_ALL_MAJORS'),
		('JFD_RITUAL_WAR_PROPHET_POINTS_ABILITY',			'MODIFIER_PLAYER_UNITS_GRANT_ABILITY',								0,			null), 
		('JFD_REVIVALISM_MISSIONARY_EXTRA_SPREADS',			'MODIFIER_PLAYER_UNITS_ADJUST_SPREAD_CHARGES',						0,			null),
		('JFD_SAINTHOOD_PATRONAGE_FAITH_DISCOUNT',			'MODIFIER_PLAYER_ADJUST_GREAT_PERSON_PATRONAGE_DISCOUNT_PERCENT',	0,			null),
		('JFD_SCHOLASTICISM_MADRASA_FAITH_MODIFIER',		'MODIFIER_PLAYER_CITIES_ADJUST_BUILDING_YIELD_CHANGE',				0,			null),
		('JFD_SCHOLASTICISM_UNIVERSITY_FAITH_MODIFIER',		'MODIFIER_PLAYER_CITIES_ADJUST_BUILDING_YIELD_CHANGE',				0,			null),
		('JFD_SECULARISM_CAMPUS_SCIENTIST_POINTS',			'MODIFIER_PLAYER_DISTRICTS_ADJUST_GREAT_PERSON_POINTS',				0,			'DISTRICT_IS_CAMPUS'),
		('JFD_SECULARISM_COMMERCIAL_HUB_MERCHANT_POINTS',	'MODIFIER_PLAYER_DISTRICTS_ADJUST_GREAT_PERSON_POINTS',				0,			'DISTRICT_IS_COMMERCIAL_HUB'),
		('JFD_SECULARISM_INDUSTRIAL_ZONE_ENGINEER_POINTS',	'MODIFIER_PLAYER_DISTRICTS_ADJUST_GREAT_PERSON_POINTS',				0,			'DISTRICT_IS_INDUSTRIAL_ZONE'),
		('JFD_SHAMANISM_UNITS_ADJUST_HEAL_PER_TURN',		'DEAD_SEA_ADJACENT_UNITS_ADJUST_HEAL_PER_TURN',						0,			null),
		('JFD_STATE_ATHEISM_FAITH_MODIFIER',				'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				0,			null),
		('JFD_STATE_ATHEISM_PRODUCTION_MODIFIER',			'MODIFIER_PLAYER_CITIES_ADJUST_CITY_YIELD_MODIFIER',				0,			null);
--------------------------------------------------------------------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,						Value)
VALUES	('JFD_ARTS_PATRONAGE_HOLY_SITE_ARTIST_POINTS',		'GreatPersonClassType',		'GREAT_PERSON_CLASS_ARTIST'),
		('JFD_ARTS_PATRONAGE_HOLY_SITE_ARTIST_POINTS',		'Amount',					1),
		('JFD_ARTS_PATRONAGE_HOLY_SITE_MUSICIAN_POINTS',	'GreatPersonClassType',		'GREAT_PERSON_CLASS_MUSICIAN'),
		('JFD_ARTS_PATRONAGE_HOLY_SITE_MUSICIAN_POINTS',	'Amount',					1),
		('JFD_ARTS_PATRONAGE_HOLY_SITE_WRITER_POINTS',		'GreatPersonClassType',		'GREAT_PERSON_CLASS_WRITER'),
		('JFD_ARTS_PATRONAGE_HOLY_SITE_WRITER_POINTS',		'Amount',					1),
		('JFD_AUTOCEPHALY_DISTRICT_PRODUCTION_MODIFIER',	'Amount',					20),
		('JFD_CROWNED_REPUBLIC_CAPITAL_APPEAL',				'Amount',					6),
		('JFD_CROWNED_REPUBLIC_CAPITAL_TOURISM',			'Amount',					50),
		('JFD_EMPIRE_BORDER_MODIFIER',						'Amount',					50),
		('JFD_FUNDAMENTALISM_SPREAD_DISTANCE',				'DistanceChange',			2),
		('JFD_FUNDAMENTALISM_SPREAD_STRENGTH',				'SpreadMultiplier',			20),
		('JFD_HOSPICES_TEMPLE_AMENITY',						'Amount',					1),
		('JFD_INVESTITURE_SHRINE_PRODUCTION',				'BuildingType',				'BUILDING_SHRINE'),
		('JFD_INVESTITURE_SHRINE_PRODUCTION',				'Amount',					50),
		('JFD_INVESTITURE_TEMPLE_PRODUCTION',				'BuildingType',				'BUILDING_TEMPLE'),
		('JFD_INVESTITURE_TEMPLE_PRODUCTION',				'Amount',					50),
		('JFD_MISSIONS_FAITH_PURCHASE_BUILDERS',			'Tag',						'CLASS_BUILDER'),
		('JFD_MISSIONS_FAITH_PURCHASE_SETTLERS',			'Tag',						'CLASS_SETTLER'),
		('JFD_RITUAL_WAR_PROPHET_POINTS_ABILITY',			'AbilityType',				'ABILITY_JFD_RITUAL_WAR_PROPHET_POINTS'),
		('JFD_PACIFISM_AT_PEACE_FAITH_MODIFIER',			'YieldType',				'YIELD_FAITH'),
		('JFD_PACIFISM_AT_PEACE_FAITH_MODIFIER',			'Amount',					10),
		('JFD_REVIVALISM_MISSIONARY_EXTRA_SPREADS',			'Amount',					2),
		('JFD_SAINTHOOD_PATRONAGE_FAITH_DISCOUNT',			'YieldType',				'YIELD_FAITH'),
		('JFD_SAINTHOOD_PATRONAGE_FAITH_DISCOUNT',			'Amount',					20),
		('JFD_SCHOLASTICISM_MADRASA_FAITH_MODIFIER',		'BuildingType',				'BUILDING_MADRASA'),
		('JFD_SCHOLASTICISM_MADRASA_FAITH_MODIFIER',		'YieldType',				'YIELD_FAITH'),
		('JFD_SCHOLASTICISM_MADRASA_FAITH_MODIFIER',		'Amount',					4),
		('JFD_SCHOLASTICISM_UNIVERSITY_FAITH_MODIFIER',		'BuildingType',				'BUILDING_UNIVERSITY'),
		('JFD_SCHOLASTICISM_UNIVERSITY_FAITH_MODIFIER',		'YieldType',				'YIELD_FAITH'),
		('JFD_SCHOLASTICISM_UNIVERSITY_FAITH_MODIFIER',		'Amount',					4),
		('JFD_SECULARISM_CAMPUS_SCIENTIST_POINTS',			'GreatPersonClassType',		'GREAT_PERSON_CLASS_SCIENTIST'),
		('JFD_SECULARISM_CAMPUS_SCIENTIST_POINTS',			'Amount',					1),
		('JFD_SECULARISM_COMMERCIAL_HUB_MERCHANT_POINTS',	'GreatPersonClassType',		'GREAT_PERSON_CLASS_MERCHANT'),
		('JFD_SECULARISM_COMMERCIAL_HUB_MERCHANT_POINTS',	'Amount',					1),
		('JFD_SECULARISM_INDUSTRIAL_ZONE_ENGINEER_POINTS',	'GreatPersonClassType',		'GREAT_PERSON_CLASS_ENGINEER'),
		('JFD_SECULARISM_INDUSTRIAL_ZONE_ENGINEER_POINTS',	'Amount',					1),
		('JFD_SHAMANISM_UNITS_ADJUST_HEAL_PER_TURN',		'Type',						'ALL'),
		('JFD_SHAMANISM_UNITS_ADJUST_HEAL_PER_TURN',		'Amount',					10),
		('JFD_STATE_ATHEISM_FAITH_MODIFIER',				'YieldType',				'YIELD_FAITH'),
		('JFD_STATE_ATHEISM_FAITH_MODIFIER',				'Amount',					-100),
		('JFD_STATE_ATHEISM_PRODUCTION_MODIFIER',			'YieldType',				'YIELD_PRODUCTION'),
		('JFD_STATE_ATHEISM_PRODUCTION_MODIFIER',			'Amount',					25);
-------------------------------------------------------------------------------------------------------------------------
-- RequirementSets
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO RequirementSets
		(RequirementSetId,									RequirementSetType)
VALUES	('JFD_CITY_HAS_PALACE_REQUIREMENTS',				'REQUIREMENTSET_TEST_ALL'),
		('JFD_CITY_HAS_TEMPLE_REQUIREMENTS',				'REQUIREMENTSET_TEST_ALL');
--------------------------------------------------------------------------------------------------------------------------
-- RequirementSetRequirements
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO RequirementSetRequirements
		(RequirementSetId,									RequirementId)
VALUES	('JFD_CITY_HAS_PALACE_REQUIREMENTS',				'JFD_REQUIRES_CITY_HAS_PALACE'),
		('JFD_CITY_HAS_TEMPLE_REQUIREMENTS',				'JFD_REQUIRES_CITY_HAS_TEMPLE');
--------------------------------------------------------------------------------------------------------------------------
-- Requirements
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO Requirements
		(RequirementId,										RequirementType)
VALUES	('JFD_REQUIRES_CITY_HAS_PALACE',					'REQUIREMENT_CITY_HAS_BUILDING'),
		('JFD_REQUIRES_CITY_HAS_TEMPLE',					'REQUIREMENT_CITY_HAS_BUILDING');
--------------------------------------------------------------------------------------------------------------------------
-- RequirementArguments
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO RequirementArguments
		(RequirementId,										Name,					Value)
VALUES	('JFD_REQUIRES_CITY_HAS_PALACE',					'BuildingType',			'BUILDING_PALACE'),
		('JFD_REQUIRES_CITY_HAS_TEMPLE',					'BuildingType',			'BUILDING_TEMPLE');
--------------------------------------------------------------------------------------------------------------------------
--Policy_Titles
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Policy_Titles
		(PolicyType,										LeaderTitle)
VALUES	('POLICY_JFD_EMPIRE',								'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE');	
--==========================================================================================================================
-- BUILDINGS
--==========================================================================================================================
-- Buildings
--------------------------------------------------------------------------------------------------------------------------
UPDATE Buildings
SET Description = 'LOC_BUILDING_JFD_FORBIDDEN_PALACE_DESCRIPTION'
WHERE BuildingType = 'BUILDING_FORBIDDEN_CITY';

UPDATE Buildings
SET Description = 'LOC_BUILDING_JFD_POTALA_PALACE_DESCRIPTION'
WHERE BuildingType = 'BUILDING_POTALA_PALACE';
--------------------------------------------------------------------------------------------------------------------------
-- BuildingModifiers
--------------------------------------------------------------------------------------------------------------------------
DELETE FROM BuildingModifiers WHERE BuildingType = 'BUILDING_POTALA_PALACE' AND ModifierId = 'POTALA_PALACE_DIPLOMATIC_GOVERNMENT_SLOT';
INSERT INTO BuildingModifiers
		(BuildingType,										ModifierId)
VALUES	('BUILDING_POTALA_PALACE', 							'JFD_POTALA_PALACE_RELIGIOUS_GOVERNMENT_SLOT');

UPDATE BuildingModifiers
SET ModifierId = 'POTALA_PALACE_DIPLOMATIC_GOVERNMENT_SLOT'
WHERE ModifierId = 'FORBIDDEN_CITY_WILDCARD_GOVERNMENT_SLOT' AND BuildingType = 'BUILDING_FORBIDDEN_CITY';
--------------------------------------------------------------------------------------------------------------------------
-- Modifiers
--------------------------------------------------------------------------------------------------------------------------					
INSERT INTO Modifiers			
		(ModifierId,										ModifierType,														RunOnce,	Permanent)
VALUES	('JFD_POTALA_PALACE_RELIGIOUS_GOVERNMENT_SLOT',		'MODIFIER_PLAYER_CULTURE_ADJUST_GOVERNMENT_SLOTS_MODIFIER',			1,			1);
--------------------------------------------------------------------------------------------------------------------------
-- ModifierArguments
--------------------------------------------------------------------------------------------------------------------------
INSERT INTO ModifierArguments
		(ModifierId,										Name,					Value)
VALUES	('JFD_POTALA_PALACE_RELIGIOUS_GOVERNMENT_SLOT',		'GovernmentSlotType',	'SLOT_JFD_RELIGIOUS');
--==========================================================================================================================
-- CIVILIZATIONS
--==========================================================================================================================
--Civilizations
--------------------------------------------------------------------------------------------------------------------------	
UPDATE Civilizations
SET Description = Description || '_JFD_CIVILIZATION'
WHERE StartingCivilizationLevelType = 'CIVILIZATION_LEVEL_FULL_CIV'
AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_CORE_CIVILIZATION_CHANGES' AND Value = 1);

CREATE TRIGGER JFDRWF_Civilizations
AFTER INSERT ON Civilizations 
WHEN EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_CORE_CIVILIZATION_CHANGES' AND Value = 1)
BEGIN
	UPDATE Civilizations
	SET Description = Description || '_JFD_CIVILIZATION'
	WHERE StartingCivilizationLevelType = 'CIVILIZATION_LEVEL_FULL_CIV' AND CivilizationType = New.CivilizationType;
END;
--==========================================================================================================================
-- LEADERS
--==========================================================================================================================
--Leader_Titles
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
VALUES	--Barbarossa			
		('LEADER_BARBAROSSA',								'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_BARBAROSSA',						0), --Chiefdom
		('LEADER_BARBAROSSA',								'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_BARBAROSSA',						0), --Autocracy
		('LEADER_BARBAROSSA',								'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_BARBAROSSA',			0), --Classical Democracy
		('LEADER_BARBAROSSA',								'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_BARBAROSSA',						0), --Oligarchy
		('LEADER_BARBAROSSA',								'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_BARBAROSSA',				0), --Merchant Republic
		('LEADER_BARBAROSSA',								'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_BARBAROSSA',				0), --Noble Republic
		('LEADER_BARBAROSSA',								'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_BARBAROSSA',				0), --Liberal Democracy
		('LEADER_BARBAROSSA',								'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_BARBAROSSA',			0), --Military Guardianship
		('LEADER_BARBAROSSA',								null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_BARBAROSSA',						0), --Empire
		--Catherin de Medicie	
		('LEADER_CATHERINE_DE_MEDICI',						'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_CATHERINE',						0), --Chiefdom
		('LEADER_CATHERINE_DE_MEDICI',						'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_CATHERINE',			0), --Classical Democracy
		('LEADER_CATHERINE_DE_MEDICI',						'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_CATHERINE',						0), --Oligarchy
		('LEADER_CATHERINE_DE_MEDICI',						'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_CATHERINE',					0), --Noble Republic
		('LEADER_CATHERINE_DE_MEDICI',						'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_CATHERINE',				0), --Liberal Democracy
		('LEADER_CATHERINE_DE_MEDICI',						null,										null,					null,																		1),
		--Cleopatra			
		('LEADER_CLEOPATRA',								'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_CLEOPATRA',						0), --Autocracy
		('LEADER_CLEOPATRA',								'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_CLEOPATRA',						0), --Oligarchy
		('LEADER_CLEOPATRA',								'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_CLEOPATRA',			0), --Classical Democracy
		('LEADER_CLEOPATRA',								'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_CLEOPATRA',				0), --Merchant Republic
		('LEADER_CLEOPATRA',								'GOVERNMENT_THEOCRACY',						null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_THEOCRACY',				0), --Merchant Republic
		('LEADER_CLEOPATRA',								'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_CLEOPATRA',					0), --Noble Republic
		('LEADER_CLEOPATRA',								'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_CLEOPATRA',			0), --Military Guardianship
		('LEADER_CLEOPATRA',								null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_CLEOPATRA',							0), --Empire
		('LEADER_CLEOPATRA',								null,										null,					null,																		1),
		--Gandhi
		('LEADER_GANDHI',									'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_GANDHI',							0), --Chiefdom
		('LEADER_GANDHI',									'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_GANDHI',							0), --Oligarchy
		('LEADER_GANDHI',									'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_GANDHI',				0), --Classical Democracy
		('LEADER_GANDHI',									'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_GANDHI',					0), --Merchant Republic
		('LEADER_GANDHI',									'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_GANDHI',							0), --Feudal Monarchy
		('LEADER_GANDHI',									'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_GANDHI',							0), --Absolute Monarchy
		('LEADER_GANDHI',									'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_GANDHI',							0), --Constitutional Monarchy
		('LEADER_GANDHI',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_GANDHI',					0), --Noble Republic
		('LEADER_GANDHI',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_GANDHI',				0), --Military Guardianship
		('LEADER_GANDHI',									null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_GANDHI',							0), --Empire
		--Gilgamesh
		('LEADER_GILGAMESH',								'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_GILGAMESH',						0), --Autocracy
		('LEADER_GILGAMESH',								'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_GILGAMESH',						0), --Oligarchy
		('LEADER_GILGAMESH',								'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_GILGAMESH',			0), --Classical Democracy
		('LEADER_GILGAMESH',								'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_GILGAMESH',				0), --Merchant Republic
		('LEADER_GILGAMESH',								'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_GILGAMESH',					0), --Noble Republic
		('LEADER_GILGAMESH',								'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_GILGAMESH',			0), --Military Guardianship
		--Gorgo		
		('LEADER_GORGO',									'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_GORGO',							0), --Feudal Monarchy
		('LEADER_GORGO',									'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_GORGO',							0), --Absolute Monarchy
		('LEADER_GORGO',									'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_GORGO',							0), --Constitutional Monarchy
		('LEADER_GORGO',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_GORGO',						0), --Noble Republic
		('LEADER_GORGO',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_GORGO',				0), --Military Guardianship
		('LEADER_GORGO',									null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_GORGO',								0), --Empire
		('LEADER_GORGO',									null,										null,					null,																		1),
		--Harald		
		('LEADER_HARDRADA',									'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_HADRADA',						0), --Autocracy
		('LEADER_HARDRADA',									'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_HADRADA',						0), --Oligarchy
		('LEADER_HARDRADA',									'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_HADRADA',				0), --Classical Democracy
		('LEADER_HARDRADA',									'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_HADRADA',				0), --Merchant Republic
		('LEADER_HARDRADA',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_HADRADA',					0), --Noble Republic
		('LEADER_HARDRADA',									'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_HADRADA',				0), --Liberal Democracy
		--Hojo		
		('LEADER_HOJO',										'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_HOJO',							0), --Chiefdom
		('LEADER_HOJO',										'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_HOJO',							0), --Autocracy
		('LEADER_HOJO',										'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_HOJO',							0), --Oligarchy
		('LEADER_HOJO',										'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_HOJO',					0), --Classical Democracy
		('LEADER_HOJO',										'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_HOJO',					0), --Merchant Republic
		('LEADER_HOJO',										'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_HOJO',							0), --Feudal Monarchy
		('LEADER_HOJO',										'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_HOJO',							0), --Absolute Monarchy
		('LEADER_HOJO',										'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_HOJO',							0), --Constitutional Monarchy
		('LEADER_HOJO',										'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_HOJO',						0), --Noble Republic
		('LEADER_HOJO',										'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_HOJO',					0), --Liberal Democracy
		('LEADER_HOJO',										'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_HOJO',				0), --Military Guardianship
		--Mvemba			
		('LEADER_MVEMBA',									'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_MVEMBA',							0), --Autocracy
		('LEADER_MVEMBA',									'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_MVEMBA',							0), --Oligarchy
		('LEADER_MVEMBA',									'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_MVEMBA',				0), --Classical Democracy
		('LEADER_MVEMBA',									'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_MVEMBA',					0), --Merchant Republic
		('LEADER_MVEMBA',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_MVEMBA',					0), --Noble Republic
		('LEADER_MVEMBA',									'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_MVEMBA',					0), --Liberal Democracy
		('LEADER_MVEMBA',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_MVEMBA',				0), --Military Guardianship
		--Pedro		
		('LEADER_PEDRO',									'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_PEDRO',							0), --Chiefdom
		('LEADER_PEDRO',									'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_PEDRO',							0), --Autocracy
		('LEADER_PEDRO',									'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_PEDRO',				0), --Classical Democracy
		('LEADER_PEDRO',									'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_PEDRO',							0), --Oligarchy
		('LEADER_PEDRO',									'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_PEDRO',					0), --Merchant Republic
		('LEADER_PEDRO',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_PEDRO',				0), --Military Guardianship
		--Pericles		
		('LEADER_PERICLES',									'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_PERICLES',						0), --Feudal Monarchy
		('LEADER_PERICLES',									'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_PERICLES',						0), --Absolute Monarchy
		('LEADER_PERICLES',									'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_PERICLES',						0), --Constitutional Monarchy
		('LEADER_PERICLES',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_PERICLES',					0), --Noble Republic
		('LEADER_PERICLES',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_PERICLES',			0), --Military Guardianship
		('LEADER_PERICLES',									null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_PERICLES',							0), --Empire
		--Peter		
		('LEADER_PETER_GREAT',								'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_PETER_GREAT',						0), --Chiefdom
		('LEADER_PETER_GREAT',								'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_PETER_GREAT',					0), --Autocracy
		('LEADER_PETER_GREAT',								'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_PETER_GREAT',			0), --Classical Democracy
		('LEADER_PETER_GREAT',								'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_PETER_GREAT',					0), --Oligarchy
		('LEADER_PETER_GREAT',								'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_PETER_GREAT',						0), --Feudal Monarchy
		('LEADER_PETER_GREAT',								'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_PETER_GREAT',						0), --Absolute Monarchy
		('LEADER_PETER_GREAT',								'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_PETER_GREAT',						0), --Constitutional Monarchy
		('LEADER_PETER_GREAT',								'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_PETER_GREAT',				0), --Noble Republic
		('LEADER_PETER_GREAT',								'GOVERNMENT_COMMUNISM',						null,					'LOC_GOVERNMENT_JFD_PEOPLES_REPUBLIC_LEADER_TITLE_PETER_GREAT',				0), --People's Republic
		('LEADER_PETER_GREAT',								'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_PETER_GREAT',			0), --Liberal Democracy
		('LEADER_PETER_GREAT',								'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_PETER_GREAT',		0), --Military Guardianship
		--Philip II		
		('LEADER_PHILIP_II',								'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_PHILIP_II',						0), --Chiefdom
		('LEADER_PHILIP_II',								'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_PHILIP_II',			0), --Classical Democracy
		('LEADER_PHILIP_II',								'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_PHILIP_II',						0), --Oligarchy
		('LEADER_PHILIP_II',								'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_PHILIP_II',			0), --Military Guardianship
		--Qin Shi Huang		
		('LEADER_QIN',										'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_QIN',								0), --Chiefdom
		('LEADER_QIN',										'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_QIN',							0), --Autocracy
		('LEADER_QIN',										'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_QIN',							0), --Oligarchy
		('LEADER_QIN',										'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_QIN',					0), --Classical Democracy
		('LEADER_QIN',										'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_QIN',					0), --Merchant Republic
		('LEADER_QIN',										'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_QIN',								0), --Feudal Monarchy
		('LEADER_QIN',										'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_QIN',								0), --Absolute Monarchy
		('LEADER_QIN',										'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_QIN',								0), --Constitutional Monarchy
		('LEADER_QIN',										'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_QIN',						0), --Noble Republic
		('LEADER_QIN',										'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_QIN',					0), --Liberal Democracy
		('LEADER_QIN',										'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_QIN',				0), --Military Guardianship
		('LEADER_QIN',										null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_QIN',								0), --Empire
		--Saladin		
		('LEADER_SALADIN',									'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_SALADIN',							0), --Chiefdom
		('LEADER_SALADIN',									'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_SALADIN',						0), --Autocracy
		('LEADER_SALADIN',									'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_SALADIN',						0), --Oligarchy
		('LEADER_SALADIN',									'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_SALADIN',				0), --Classical Democracy
		('LEADER_SALADIN',									'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_SALADIN',				0), --Merchant Republic
		('LEADER_SALADIN',									'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_SALADIN',							0), --Feudal Monarchy
		('LEADER_SALADIN',									'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_SALADIN',							0), --Absolute Monarchy
		('LEADER_SALADIN',									'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_SALADIN',							0), --Constitutional Monarchy
		('LEADER_SALADIN',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_SALADIN',					0), --Noble Republic
		('LEADER_SALADIN',									'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_SALADIN',				0), --Liberal Democracy
		('LEADER_SALADIN',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_SALADIN',			0), --Military Guardianship
		('LEADER_SALADIN',									null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_SALADIN',							0), --Empire
		--Tomyris		
		('LEADER_TOMYRIS',									'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_TOMYRIS',						0), --Autocracy
		('LEADER_TOMYRIS',									'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_TOMYRIS',				0), --Classical Democracy
		('LEADER_TOMYRIS',									'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_TOMYRIS',						0), --Oligarchy
		('LEADER_TOMYRIS',									'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_TOMYRIS',				0), --Merchant Republic
		('LEADER_TOMYRIS',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_TOMYRIS',					0), --Noble Republic
		('LEADER_TOMYRIS',									null,										null,					null,																		1),
		--Trajan		
		('LEADER_TRAJAN',									'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_TRAJAN',							0), --Chiefdom
		('LEADER_TRAJAN',									'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_TRAJAN',							0), --Autocracy
		('LEADER_TRAJAN',									'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_TRAJAN',							0), --Feudal Monarchy
		('LEADER_TRAJAN',									'GOVERNMENT_THEOCRACY',						null,					'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_TRAJAN',							0), --Theocracy
		('LEADER_TRAJAN',									'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_TRAJAN',							0), --Absolute Monarchy
		('LEADER_TRAJAN',									'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',	null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_TRAJAN',							0), --Constitutional Monarchy
		('LEADER_TRAJAN',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_TRAJAN',					0), --Noble Republic
		('LEADER_TRAJAN',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_TRAJAN',				0), --Military Guardianship
		('LEADER_TRAJAN',									null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_TRAJAN',							0), --Empire
		--Teddy Roosevelt		
		('LEADER_T_ROOSEVELT',								'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_T_ROOSEVELT',						0), --Chiefdom
		('LEADER_T_ROOSEVELT',								'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_T_ROOSEVELT',					0), --Autocracy
		('LEADER_T_ROOSEVELT',								'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_T_ROOSEVELT',			0), --Classical Democracy
		('LEADER_T_ROOSEVELT',								'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_T_ROOSEVELT',					0), --Oligarchy
		('LEADER_T_ROOSEVELT',								'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_T_ROOSEVELT',			0), --Merchant Republic
		('LEADER_T_ROOSEVELT',								'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_T_ROOSEVELT',				0), --Noble Republic
		('LEADER_T_ROOSEVELT',								'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_T_ROOSEVELT',		0), --Military Guardianship
		--Victoria		
		('LEADER_VICTORIA',									'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_VICTORIA',						0), --Chiefdom
		('LEADER_VICTORIA',									'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_VICTORIA',				0), --Classical Democracy
		('LEADER_VICTORIA',									'GOVERNMENT_OLIGARCHY',						null,					'LOC_GOVERNMENT_JFD_OLIGARCHY_LEADER_TITLE_VICTORIA',						0), --Oligarchy
		('LEADER_VICTORIA',									'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_VICTORIA',					0), --Noble Republic
		('LEADER_VICTORIA',									'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_VICTORIA',				0), --Liberal Democracy
		('LEADER_VICTORIA',									'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_VICTORIA',			0), --Military Guardianship
		('LEADER_VICTORIA',									null,										null,					null,																		1);	
		
INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_CHIEFDOM',						null,					'LOC_GOVERNMENT_JFD_CHIEFDOM_LEADER_TITLE_MONTEZUMA',						0 --Chiefdom	
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_AUTOCRACY',						null,					'LOC_GOVERNMENT_JFD_AUTOCRACY_LEADER_TITLE_MONTEZUMA',						0 --Autocracy	
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_CLASSICAL_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_CLASSICAL_DEMOCRACY_LEADER_TITLE_MONTEZUMA',			0 --Classical Democracy
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_MERCHANT_REPUBLIC',				null,					'LOC_GOVERNMENT_JFD_MERCHANT_REPUBLIC_LEADER_TITLE_MONTEZUMA',				0 --Merchant Republic
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_MONARCHY',						null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_MONTEZUMA',						0 --Feudal Monarchy
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_JFD_ABSOLUTE_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_MONTEZUMA',						0 --Absolute Monarchy
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_JFD_CONSTITUTIONAL_MONARCHY',			null,					'LOC_GOVERNMENT_JFD_MONARCHY_LEADER_TITLE_MONTEZUMA',				0 --Constitutional Monarchy
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_JFD_NOBLE_REPUBLIC',			null,					'LOC_GOVERNMENT_JFD_NOBLE_REPUBLIC_LEADER_TITLE_MONTEZUMA',					0 --Noble Republic
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_DEMOCRACY',						null,					'LOC_GOVERNMENT_JFD_LIBERAL_DEMOCRACY_LEADER_TITLE_MONTEZUMA',				0 --Liberal Democracy
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											'GOVERNMENT_FASCISM',						null,					'LOC_GOVERNMENT_JFD_MILITARY_GUARDIANSHIP_LEADER_TITLE_MONTEZUMA',			0 --Military Guardianship
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

INSERT INTO Leader_Titles															
		(LeaderType,										GovernmentType,								PolicyType,				LeaderTitle,																UseFeminine)
SELECT  LeaderType,											null,										'POLICY_JFD_EMPIRE',	'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_MONTEZUMA',							0 --Empire
FROM Leaders WHERE LeaderType = 'LEADER_MONTEZUMA';

--Qin Shi Huang update
-- UPDATE Leader_Titles
-- SET LeaderTitle = 'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_YING_ZHENG'
-- WHERE LeaderType = 'LEADER_QIN' AND LeaderTitle = 'LOC_GOVERNMENT_JFD_EMPIRE_LEADER_TITLE_QIN'
-- AND EXISTS (SELECT * FROM JFD_GlobalUserSettings WHERE Type = 'JFD_RWF_GOVERNMENT_CORE_LEADER_CHANGES_QIN' AND Value = 1);
--==========================================================================================================================
-- RELIGIONS
--==========================================================================================================================
--Religion_Titles
--------------------------------------------------------------------------------------------------------------------------	
INSERT INTO Religion_Titles
		(ReligionType,										GovernmentType,				LeaderTitle)
VALUES	('RELIGION_BUDDHISM',								'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_BUDDHISM'),
		('RELIGION_CATHOLICISM',							'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_CATHOLICISM'),
		('RELIGION_CONFUCIANISM',							'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_CONFUCIANISM'),
		('RELIGION_HINDUISM',								'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_HINDUISM'),
		('RELIGION_ISLAM',									'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_ISLAM'),
		('RELIGION_JUDAISM',								'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_JUDAISM'),
		('RELIGION_ORTHODOXY',								'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_ORTHODOXY'),
		('RELIGION_PROTESTANTISM',							'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_PROTESTANTISM'),
		('RELIGION_SHINTO',									'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_SHINTO'),
		('RELIGION_SIKHISM',								'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_SIKHISM'),
		('RELIGION_TAOISM',									'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_TAOISM'),
		('RELIGION_ZOROASTRIANISM',							'GOVERNMENT_THEOCRACY',		'LOC_GOVERNMENT_JFD_THEOCRACY_LEADER_TITLE_ZOROASTRIANISM');		
--==========================================================================================================================
--==========================================================================================================================